% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move_to.r
\name{move_to}
\alias{move_to}
\alias{copy_df_to}
\title{Move or copy a disk.frame to another location}
\usage{
move_to(df, outdir, ..., copy = FALSE)

copy_df_to(df, outdir, ...)
}
\arguments{
\item{df}{The disk.frame}

\item{outdir}{The new location}

\item{...}{NOT USED}

\item{copy}{Merely copy and not move}
}
\value{
a disk.frame
}
\description{
Move or copy a disk.frame to another location
}
\examples{
cars.df = as.disk.frame(cars)

cars_copy.df = copy_df_to(cars.df, outdir = tempfile(fileext=".df"))

cars2.df = move_to(cars.df, outdir = tempfile(fileext=".df"))

# clean up
delete(cars_copy.df)
delete(cars2.df)
}
