% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sas_to_csv.r, R/sas_to_disk.frame.r
\name{sas_to_csv}
\alias{sas_to_csv}
\alias{sas_to_disk.frame}
\title{Convert a SAS file (.sas7bdat) format to CSV by chunks}
\usage{
sas_to_csv(infile, chunk,
  nchunks = disk.frame::recommend_nchunks(fs::file_size(infile)))

sas_to_disk.frame(inpath, outpath,
  nchunks = disk.frame::recommend_nchunks(inpath))
}
\arguments{
\item{infile}{the SAS7BDAT file}

\item{chunk}{which convert of nchunks to convert}

\item{nchunks}{number of chunks}

\item{inpath}{input SAS7BDAT file}

\item{outpath}{output disk.frame}
}
\description{
Convert a SAS file (.sas7bdat) format to CSV by chunks
}
