% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_cluster_utils.R
\name{hc_mapa}
\alias{hc_mapa}
\title{PCA plot of individuals colored by clusters}
\usage{
hc_mapa(
  pca.model,
  clusters,
  nombre.archivo = NULL,
  colores = NULL,
  ejes = c(1, 2)
)
}
\arguments{
\item{pca.model}{an object of class PCA [FactoMineR].}

\item{clusters}{a vector specifying the cluster of each individual.}

\item{nombre.archivo}{a character value specifying the name to use when the plot is downloaded.}

\item{colores}{a vector of color for each cluster.}

\item{ejes}{a numeric vector of length 2 specifying the dimensions to be plotted.}
}
\value{
Highchart plot
}
\description{
PCA plot of individuals colored by clusters
}
\examples{
p <- discoveR:::PCA(iris[, -5], graph = FALSE)
clusters <- factor(kmeans(iris[, -5], 3)$cluster)
hc_mapa(p, clusters, "map", c("steelblue", "pink", "forestgreen"))

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
