# twoStepsBenchmark works

    Code
      print(twoStepsBenchmark(mensualts, trimts, include.differenciation = TRUE),
      digits = 4L)
    Output
      
      Call:
      twoStepsBenchmark(hfserie = mensualts, lfserie = trimts, include.differenciation = TRUE)
      
      Coefficients:
      constant   hfserie  
       13.9409   -0.2365  
      
                 Jan       Feb       Mar       Apr       May       Jun       Jul
      2010                               -13.22507 -11.71372 -10.72874  -9.11931
      2011  -1.19387   0.08591   1.10796   2.61006   4.17807   5.52778   7.09374
      2012  15.45056  16.54021  17.50542  18.65069  19.76940  21.15127  22.12815
                 Aug       Sep       Oct       Nov       Dec
      2010  -7.82346  -6.91584  -5.46079  -4.03665  -2.57391
      2011   8.43906   9.89280  11.72185  12.97733  14.35113
      2012  23.08607  24.55395  26.06812                    

---

    Code
      print(bn, digits = 4L)
    Output
      
      Call:
      twoStepsBenchmark(hfserie = mensualts, lfserie = trimts, include.differenciation = TRUE)
      
      Coefficients:
      constant   hfserie  
       14.9712   -0.2195  
      
                Jan      Feb      Mar      Apr      May      Jun      Jul      Aug
      2010                   -15.3353 -13.8946 -12.6423 -10.9727  -9.6793  -8.3340
      2011  -1.3817  -0.0421   1.4238   2.8231   4.2877   5.7096   7.2125   8.3609
      2012  15.7208  16.9586  18.3233  19.6048  20.8551  22.1830  24.0770  25.3054
                Sep      Oct      Nov      Dec
      2010  -6.9794  -5.5980  -4.0170  -2.7573
      2011   9.8370  11.2700  12.5310  14.0388
      2012  26.6454                           

---

    Code
      print(twoStepsBenchmark(turnover, construction, include.differenciation = TRUE,
        include.rho = TRUE), digits = 4L)
    Output
      
      Call:
      twoStepsBenchmark(hfserie = turnover, lfserie = construction, 
          include.differenciation = TRUE, include.rho = TRUE)
      
      Coefficients:
      constant   hfserie  
       -1.4628    0.1658  
      
             Jan   Feb   Mar   Apr   May   Jun   Jul   Aug   Sep   Oct   Nov   Dec
      2000 11.18 11.05 11.31 11.38 11.48 11.50 11.72 11.66 11.70 11.74 11.73 11.96
      2001 11.89 12.04 11.99 11.92 11.98 11.96 11.76 12.12 11.81 12.15 12.10 12.18
      2002 12.05 12.00 12.02 12.34 12.28 12.24 12.23 12.41 12.44 12.55 12.33 12.43
      2003 12.54 12.73 12.75 12.78 12.62 12.93 12.99 13.24 13.18 13.33 13.34 13.47
      2004 13.73 13.75 13.75 14.01 13.99 14.02 14.18 13.98 14.33 14.46 14.52 14.57
      2005 14.53 14.59 14.68 14.83 14.83 14.93 15.25 15.34 15.50 15.48 15.86 15.57
      2006 15.77 15.94 16.16 16.16 16.50 16.67 16.81 16.75 16.94 16.88 17.13 17.51
      2007 17.62 17.79 17.87 17.76 18.19 18.17 18.12 18.12 18.22 18.35 18.07 18.42
      2008 18.93 19.03 19.44 19.04 18.81 19.07 19.01 19.10 18.89 18.94 18.33 18.40
      2009 18.05 17.97 17.87 17.86 17.61 17.62 17.66 17.47 17.31 17.41 17.34 17.62
      2010 17.32 17.04 17.01 17.08 17.32 17.49 17.61 17.52 17.87 17.76 18.12 17.96
      2011 18.05 18.08 18.22 18.27 18.42 18.27 18.74 18.25 18.35 18.31 18.76 18.76
      2012 18.45 18.19 18.49 18.43 18.51 18.33 18.64 18.31 18.19 18.33 18.03 18.03
      2013 18.34 18.08 17.68 18.33 18.31 18.17 18.44 18.54 18.36 18.26 18.67 18.93
      2014 17.93 18.29 18.24 18.12 17.83 18.34 17.89 18.44 17.98 17.88 17.58 17.78
      2015 17.53 17.48 17.45 17.37 17.04 17.46 17.36 17.27 17.25 17.38 17.56 17.35
      2016 17.26 17.55 17.24 17.14 17.54 17.15 17.20 17.23 17.67 17.55 17.83 17.63
      2017 17.77 17.98 18.43 17.63 18.76 19.03 18.60 18.34 18.54 18.56 18.72 19.25
      2018 19.13 19.17 18.49 19.26 18.72 19.39 19.00 19.59 19.27 19.83 19.60 19.86
      2019 19.86 20.12 20.59 20.59 20.57 20.04 20.06 21.21 20.63 20.48 20.53 20.42
      2020 20.51 19.72 18.76 16.26 14.93                                          

# mts works

    Code
      print(bn, digits = 4L)
    Output
      
      Call:
      twoStepsBenchmark(hfserie = ts(matrix(rnorm(900, 0, 100), ncol = 3), 
          start = c(2000, 1), freq = 12) %>% `colnames<-`(c("a", "b", 
          "c")), lfserie = construction)
      
      Coefficients:
       constant          a          b          c  
      195.92267   -0.04149    0.04151   -0.03095  
      
               Jan     Feb     Mar     Apr     May     Jun     Jul     Aug     Sep
      2000  8.9192 12.9307  8.8983 15.5714 12.4968 23.0869  9.6324 14.6192  9.1798
      2001 15.2869 12.2074 27.8984  8.0689 13.7004 16.0877  7.6710 23.4964  2.4404
      2002 29.7242 10.3385 13.0226 21.3500 12.4604  8.4857 15.1285  2.6048  1.9850
      2003  9.2314  8.1953  8.8072 20.0896 21.3545  6.0228 18.4605 16.5264 10.4236
      2004  6.6303 10.7262 24.4171 16.7715 13.1559 17.6766 14.1494 16.0598 15.5979
      2005 13.5783  1.4121 14.0240 13.4653 23.5198  2.1607 15.5528 25.8701 16.5581
      2006 14.5523 14.3711 22.8532 17.0330 18.8009 15.2492 13.5389  8.6861 23.4987
      2007 16.6790 19.7514 18.5696 26.4854 18.2192  6.5756  6.7398 23.3637 28.2014
      2008 17.8886 18.2244 15.1573 18.1028 20.3658 15.6009 20.0590 17.0378 17.7701
      2009  4.0682  6.5682 18.2888 18.5963 28.9742 24.0960 24.5712 19.7457 29.5188
      2010 21.2764 19.8412 18.5320 12.6482 28.7500 16.2672 23.0370 17.1961  7.6750
      2011 17.5160 16.6008 15.4379 19.6419 29.7723  8.0067  7.4779 25.9538 20.2374
      2012 20.6360 11.2410 12.4485 29.0450 27.8560 24.6755 16.7548 24.0305 14.5129
      2013 10.5718 19.6843 15.3910  8.2383 22.3224 16.3074 27.7701 25.9731 17.8305
      2014 14.1027  7.7773 21.0298 17.2646 28.1581 19.9824  5.9469 24.5598 24.0197
      2015 19.1756 20.3459 12.0443 22.7867  7.0740 13.7778 15.3252 20.5808 22.5837
      2016 18.9567 11.2893 15.1248  7.1197 17.8325 21.0814 12.9926 19.6656 26.5917
      2017 19.1103 24.9788 15.1063  8.5717 11.5629 26.6717 10.9062 27.5308 23.7964
      2018 25.6505 14.6281 21.7840 25.8935 21.4854 16.0307 28.0410 15.6196  9.6256
      2019 18.1001 17.8531 16.5083 17.6731 18.6768 28.2575 12.1728 22.3719 23.4784
      2020 19.9301 23.4059 20.7984  7.2617 14.5336 23.9072 16.7180 14.8701  4.7702
      2021 15.6001  8.0088 18.2338  5.1724 18.8949 13.3511 19.4440  6.6494 27.3058
      2022 13.4049 16.2957 13.2209 14.6113 22.3219 25.1938 16.5567 13.6968  7.3335
      2023 21.4655 13.1182 17.9597  8.1936 21.0257 27.2335 23.2356 20.6971 32.0529
      2024 12.4271 10.7532 13.3334 12.8643 22.8533  8.9542 17.1529  6.3620 17.4421
               Oct     Nov     Dec
      2000  2.0401 12.0718  8.9536
      2001 -0.7203 -2.8681 20.6310
      2002  8.3257 19.6154  4.2593
      2003 16.7575 14.1957  5.8357
      2004 17.5518  9.3944  7.1691
      2005 13.9583 20.2058 21.0946
      2006 15.2155 16.5008 18.9002
      2007 14.8523 11.6105 25.6520
      2008 15.7726 16.4578 34.5631
      2009 13.0261  6.0398 18.3068
      2010 13.8714  9.5713 21.4342
      2011 17.9815 19.6468 22.2270
      2012 14.5548 10.7432 13.4018
      2013 23.1996 29.8782  2.9333
      2014 15.3897 19.4165 18.6526
      2015 22.1013 15.5900 17.1148
      2016 27.1868 13.2451 17.9137
      2017 15.8612 18.3514 19.1522
      2018 18.9953 34.0821 -0.5359
      2019 27.1089 15.4172 27.4819
      2020 15.2378 20.1625 25.4526
      2021 17.8276 19.0864 20.7509
      2022 24.4147 19.2607 13.8316
      2023 19.9212 18.2516 34.4469
      2024 17.3337 14.2663 19.7291

# reUseBenchmark works

    Code
      print(benchmark2, digits = 4L)
    Output
      
      Call:
      reUseBenchmark(hfserie = adjusted_turnover, benchmark = benchmark1)
      
      Coefficients:
      constant   hfserie    LS2009  
      -0.86421   0.16072  -0.03049  
      
             Jan   Feb   Mar   Apr   May   Jun   Jul   Aug   Sep   Oct   Nov   Dec
      2006 15.80 15.95 16.18 16.19 16.52 16.65 16.81 16.71 16.96 16.87 17.11 17.45
      2007 17.65 17.80 17.89 17.80 18.21 18.15 18.13 18.09 18.24 18.33 18.05 18.36
      2008 18.93 19.01 19.42 19.05 18.82 19.04 19.01 19.06 18.92 18.94 18.36 18.42
      2009 18.14 18.04 17.94 17.93 17.65 17.61 17.66 17.42 17.30 17.35 17.26 17.50
      2010 17.30 17.02 17.02 17.11 17.34 17.48 17.62 17.50 17.90 17.76 18.11 17.92
      2011 18.09 18.11 18.25 18.31 18.45 18.26 18.73 18.22 18.37 18.30 18.72 18.70
      2012 18.48 18.20 18.51 18.46 18.53 18.31 18.63 18.27 18.21 18.32 18.01 17.98
      2013 18.37 18.10 17.72 18.36 18.34 18.17 18.44 18.49 18.38 18.24 18.63 18.85
      2014 17.97 18.30 18.27 18.16 17.87 18.32 17.90 18.39 18.00 17.86 17.56 17.72
      2015 17.56 17.49 17.48 17.41 17.07 17.44 17.36 17.23 17.27 17.36 17.53 17.29
      2016 17.29 17.56 17.27 17.18 17.56 17.14 17.21 17.20 17.68 17.53 17.80 17.58
      2017 17.80 17.99 18.44 17.68 18.77 19.00 18.60 18.31 18.56 18.55 18.70 19.19
      2018 19.16 19.18 18.53 19.29 18.76 19.37 19.01 19.54 19.29 19.80 19.57 19.80
      2019 19.88 20.12 20.58 20.60 20.57 20.03 20.08 21.15 20.65 20.48 20.54 20.41

---

    Code
      print(benchmark3, digits = 4L)
    Output
      
      Call:
      reUseBenchmark(hfserie = adjusted_turnover, benchmark = benchmark1, 
          reeval.smoothed.part = TRUE)
      
      Coefficients:
      constant   hfserie    LS2009  
      -0.86421   0.16072  -0.03049  
      
             Jan   Feb   Mar   Apr   May   Jun   Jul   Aug   Sep   Oct   Nov   Dec
      2006 15.84 15.98 16.20 16.20 16.52 16.65 16.80 16.69 16.94 16.85 17.09 17.44
      2007 17.63 17.79 17.89 17.80 18.21 18.16 18.13 18.09 18.24 18.34 18.05 18.36
      2008 18.94 19.02 19.43 19.05 18.82 19.04 19.01 19.06 18.92 18.94 18.36 18.42
      2009 18.14 18.04 17.94 17.92 17.65 17.61 17.66 17.42 17.30 17.35 17.26 17.50
      2010 17.30 17.02 17.02 17.11 17.34 17.48 17.62 17.50 17.90 17.76 18.11 17.92
      2011 18.09 18.11 18.25 18.31 18.45 18.26 18.73 18.22 18.37 18.30 18.72 18.70
      2012 18.48 18.20 18.51 18.46 18.53 18.31 18.63 18.27 18.21 18.32 18.01 17.98
      2013 18.37 18.10 17.72 18.36 18.34 18.17 18.44 18.49 18.38 18.24 18.63 18.85
      2014 17.97 18.30 18.27 18.16 17.87 18.32 17.90 18.39 18.00 17.86 17.56 17.72
      2015 17.56 17.49 17.48 17.41 17.07 17.44 17.36 17.23 17.27 17.36 17.53 17.29
      2016 17.29 17.56 17.27 17.18 17.56 17.14 17.21 17.20 17.68 17.53 17.80 17.59
      2017 17.80 17.99 18.45 17.69 18.77 19.00 18.60 18.31 18.56 18.55 18.70 19.19
      2018 19.15 19.18 18.53 19.28 18.75 19.37 19.01 19.55 19.29 19.80 19.57 19.81
      2019 19.89 20.13 20.60 20.61 20.58 20.04 20.08 21.15 20.64 20.47 20.52 20.38

# annualBenchmark

    Code
      print(annualBenchmark(turnover, construction, end.coeff.calc = 2018), digits = 4L)
    Output
      
      Call:
      annualBenchmark(hfserie = turnover, lfserie = construction, end.coeff.calc = 2018)
      
      Coefficients:
      constant   hfserie  
       41.6754    0.1437  
      
             Jan   Feb   Mar   Apr   May   Jun   Jul   Aug   Sep   Oct   Nov   Dec
      2000 11.19 11.08 11.31 11.38 11.48 11.50 11.70 11.65 11.70 11.73 11.74 11.94
      2001 11.88 12.02 11.98 11.92 11.98 11.96 11.79 12.11 11.85 12.14 12.10 12.17
      2002 12.06 12.01 12.03 12.32 12.27 12.24 12.23 12.39 12.43 12.53 12.35 12.44
      2003 12.55 12.72 12.74 12.78 12.65 12.93 12.99 13.22 13.18 13.33 13.35 13.47
      2004 13.71 13.75 13.76 13.99 13.99 14.03 14.17 14.02 14.33 14.45 14.52 14.57
      2005 14.54 14.61 14.69 14.83 14.84 14.95 15.23 15.33 15.48 15.48 15.82 15.59
      2006 15.78 15.95 16.16 16.17 16.49 16.65 16.79 16.75 16.94 16.90 17.14 17.48
      2007 17.59 17.75 17.84 17.76 18.15 18.15 18.12 18.14 18.24 18.37 18.14 18.46
      2008 18.92 19.02 19.39 19.05 18.85 19.07 19.02 19.09 18.89 18.92 18.38 18.42
      2009 18.08 17.99 17.89 17.86 17.62 17.62 17.64 17.47 17.32 17.40 17.33 17.58
      2010 17.32 17.07 17.05 17.12 17.32 17.48 17.59 17.52 17.84 17.76 18.08 17.95
      2011 18.05 18.09 18.22 18.28 18.42 18.30 18.70 18.28 18.37 18.34 18.72 18.72
      2012 18.45 18.21 18.47 18.41 18.48 18.32 18.59 18.30 18.20 18.33 18.06 18.06
      2013 18.34 18.11 17.77 18.33 18.32 18.20 18.43 18.51 18.36 18.27 18.62 18.84
      2014 17.98 18.28 18.24 18.13 17.87 18.31 17.91 18.38 17.97 17.88 17.60 17.77
      2015 17.54 17.49 17.46 17.38 17.09 17.45 17.36 17.27 17.25 17.37 17.52 17.33
      2016 17.25 17.51 17.24 17.16 17.51 17.18 17.22 17.26 17.65 17.55 17.82 17.65
      2017 17.79 17.98 18.39 17.71 18.70 18.95 18.59 18.37 18.56 18.59 18.75 19.22
      2018 19.12 19.17 18.59 19.26 18.80 19.38 19.04 19.56 19.28 19.76 19.55 19.78
      2019 19.77 20.00 20.41 20.43 20.44 20.02 20.08 21.13 20.69 20.63 20.76 20.75
      2020 20.93 20.33 19.58 17.48 16.39    NA    NA    NA    NA    NA    NA    NA
      2021    NA    NA    NA    NA    NA    NA    NA    NA    NA    NA    NA    NA

