% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in.R
\name{in_disaggr}
\alias{in_disaggr}
\title{Comparing a disaggregation with the high-frequency input}
\usage{
in_disaggr(object, type = "changes")
}
\arguments{
\item{object}{an object of class \code{"twoStepsBenchmark"} or \code{"threeRuleSmooth"}.}

\item{type}{\code{"levels"},\code{"levels-rebased"}, \code{"changes"} or \code{"contributions"}.
This defines the type of output.}
}
\value{
a named matrix time-serie of two columns, one for the response and the other
for the input.
A \code{tscomparison} class is added to the object.
}
\description{
The function \code{in_disaggr} takes a \link{twoStepsBenchmark} or a
\link{threeRuleSmooth} object as an input. It produces a comparison between
the benchmarked time-serie and the high-frequency input.
}
\details{
The functions \code{plot} and \code{autoplot} can be used on this object to produce
graphics.
}
\examples{
benchmark <- twoStepsBenchmark(turnover,construction,include.rho = TRUE)
plot(in_disaggr(benchmark))
}
\seealso{
\link{in_sample} \link{in_revisions} \link{in_scatter}
\link{plot.tscomparison}
}
