% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_prepare_data.R
\name{dp_prepare_data_table}
\alias{dp_prepare_data_table}
\title{function for preparing data for tabulation}
\usage{
dp_prepare_data_table(dp, link = NULL, align_var = TRUE, text_var = TRUE,
  aggregate_function = NULL, ...)
}
\arguments{
\item{dp}{an object of type diffrproject}

\item{link}{which link to produce table for}

\item{align_var}{either a character vector of variable names or TRUE for all}

\item{text_var}{either a character vector of variable names or TRUE for all}

\item{aggregate_function}{a function able to resolve conflicts if for a
specific variable for a token of text severla values exist, if NULL it
defaults to modus() but could also be e.g. paste or something alike}

\item{...}{further arguments passed through to aggregate_function}
}
\description{
function for preparing data for tabulation
}
\examples{

library(diffrprojects)
library(diffrprojectswidget)

dp <-
diffrproject$new()$
  text_add(list(text_version_1, text_version_2))$
  text_link()$
  text_align( maxDist = 1 )

dp$text_code_regex(
  text    = 1,
  x       = "change",
  pattern = "change",
  val     = "change"
)

dp_prepare_data_table(dp)


}

