% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difNLR.R
\name{logLik.difNLR}
\alias{logLik.difNLR}
\alias{AIC.difNLR}
\alias{BIC.difNLR}
\title{Loglikelihood and information criteria for an object of \code{"difNLR"} class.}
\usage{
\method{logLik}{difNLR}(object, item = "all", ...)

\method{AIC}{difNLR}(object, item = "all", ...)

\method{BIC}{difNLR}(object, item = "all", ...)
}
\arguments{
\item{object}{an object of \code{"difNLR"} class.}

\item{item}{numeric or character: either character \code{"all"} to apply for all converged items (default),
or a vector of item names (column names of \code{Data}), or item identifiers (integers specifying
the column number).}

\item{...}{other generic parameters for S3 methods.}
}
\description{
S3 methods for extracting loglikelihood, Akaike's information criterion (AIC) and
Schwarz's Bayesian criterion (BIC) for an object of \code{"difNLR"} class.
}
\examples{
\dontrun{
# Loading data based on GMAT
data(GMAT)

Data <- GMAT[, 1:20]
group <- GMAT[, "group"]

# Testing both DIF effects using likelihood-ratio test and
# 3PL model with fixed guessing for groups
(x <- difNLR(Data, group, focal.name = 1, model = "3PLcg"))

# AIC, BIC, log-likelihood
AIC(x)
BIC(x)
logLik(x)

# AIC, BIC, log-likelihood for the first item
AIC(x, item = 1)
BIC(x, item = 1)
logLik(x, item = 1)
}
}
\references{
Drabinova, A. & Martinkova, P. (2017). Detection of Differential Item Functioning with NonLinear Regression:
Non-IRT Approach Accounting for Guessing. Journal of Educational Measurement, 54(4), 498-517,
\url{https://doi.org/10.1111/jedm.12158}.

Swaminathan, H. & Rogers, H. J. (1990). Detecting Differential Item Functioning Using Logistic Regression Procedures.
Journal of Educational Measurement, 27(4), 361-370,
\url{https://doi.org/10.1111/j.1745-3984.1990.tb00754.x}
}
\seealso{
\code{\link[difNLR]{difNLR}} for DIF detection among binary data using generalized logistic regression model. \cr
\code{\link[stats]{logLik}} for generic function extracting loglikelihood. \cr
\code{\link[stats]{AIC}} for generic function calculating AIC and BIC.
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr

Karel Zvara \cr
Faculty of Mathematics and Physics, Charles University \cr
}
