% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emPolarise.r
\name{emPolarise}
\alias{emPolarise}
\title{Polarises a marker}
\usage{
emPolarise(origM, changePolarity = TRUE)
}
\arguments{
\item{origM}{A character vector of genotypes comprising of _012 encodings.}

\item{changePolarity}{A logical scalar, indicating whether to leave the marker as is
(\code{FALSE}) or whether to change its polarity (\code{TRUE}).}
}
\value{
Returns a character vector with polarised markers.
}
\description{
Changes encodings of genomic markers according to user specification.
}
\note{
Note that \link{diem} and \link{importPolarized} accept also a \code{U}
encoding for an unknown or third allele, but \code{emPolarise} requires all \code{U} to
be replaced with \verb{_}.
}
\examples{
emPolarise(c("0", "0", "1", "2", "2"), TRUE)
# [1] "2" "2" "1" "0" "0"

emPolarise(c("0", "_", "2", "2", "1"), FALSE)
# [1] "0" "_" "2" "2" "1"
}
\seealso{
\code{\link{diem}} for determining appropriate marker polarity with
respect to a barrier to geneflow.
}
