% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/did.R
\name{mp.spatt.test}
\alias{mp.spatt.test}
\title{mp.spatt.test}
\usage{
mp.spatt.test(formla, xformlalist = NULL, data, tname, weightfun = NULL,
  w = NULL, panel = FALSE, idname = NULL, first.treat.name, alp = 0.05,
  method = "logit", biters = 100, clustervarlist = NULL, pl = FALSE,
  cores = 2)
}
\arguments{
\item{formla}{The formula y ~ d where y is the outcome and d is the
treatment indicator (d should be binary)}

\item{xformlalist}{A list of formulas for the X variables.  This allows to
test using different specifications for X, if desired}

\item{data}{The name of the data.frame that contains the data}

\item{tname}{The name of the column containing the time periods}

\item{weightfun}{A function that takes in two arguments, X and u, to compute
the weighting function for the test.  The default is \code{1*(X <= u)}}

\item{w}{A vector of weights for each observation (not implemented)}

\item{panel}{Boolean indicating whether the data is panel or repeated cross
sections}

\item{idname}{The individual (cross-sectional unit) id name}

\item{first.treat.name}{The name of the variable in \code{data} that contains the first
period when a particular observation is treated}

\item{alp}{the significance level, default is 0.05}

\item{method}{The method for estimating the propensity score when covariates
are included}

\item{biters}{The number of boostrap iterations to use.  The default is 100,
and this is only applicable if \code{bstrap=TRUE}.}

\item{clustervarlist}{A list of cluster variables.  This allows to conduct
the test using different levels of clustering, if desired.}

\item{pl}{Boolean for whether or not to use parallel processing}

\item{cores}{The number of cores to use for parallel processing}
}
\value{
list containing test results
}
\description{
integrated moments test for conditional common trends holding in all pre-treatment time
 periods across all groups
}
\examples{
\dontrun{
data(mpdta)
mptest <- mp.spatt.test(lemp ~ treat, xformla=list(~lpop), data=mpdta,
                panel=TRUE, first.treat.name="first.treat",
                idname="countyreal", tname="year", clustervarlist=list(NULL))
summary(mptest[[1]])
}

}
