% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_engine_earth.R
\name{max_num_terms}
\alias{max_num_terms}
\title{Parameters for possible engine parameters for earth models}
\usage{
max_num_terms(range = c(20L, 200L), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
These parameters are auxiliary to models that use the "earth"
engine. They correspond to tuning parameters that would be specified using
\code{set_engine("earth", ...)}.
}
\details{
To use these, check \code{?earth::earth} to see how they are used.
}
\examples{
max_num_terms()
}
