% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ngram_from_book.R
\name{get_ngram_from_books}
\alias{get_ngram_from_books}
\title{Get Ngram Count per Year for National Library Book Collection}
\usage{
get_ngram_from_books(
  city = NULL,
  ddk = NULL,
  lang = NULL,
  period = list(),
  publisher = NULL,
  title = NULL,
  topic = NULL,
  word = list("hus", "blokk")
)
}
\arguments{
\item{city}{(character, optional) The city of publication. Default is NULL.}

\item{ddk}{(character, optional) The Dewey Decimal Classification (DDC) code. Default is NULL.}

\item{lang}{(character, optional) The language code of the books. Default is NULL.}

\item{period}{(list, optional) A list containing the start and end years of the period to search. Default is an empty list.}

\item{publisher}{(character, optional) The publisher's name. Default is NULL.}

\item{title}{(character, optional) The title or a part of the title of the books. Default is NULL.}

\item{topic}{(character, optional) A topic or subject associated with the books. Default is NULL.}

\item{word}{(list, optional) A list of words (ngrams) to search for in the books. Default is list("hus", "blokk").}
}
\value{
A data frame with the ngram count per year for the specified parameters.
}
\description{
This function queries the National Library's book collection API to retrieve
the ngram count per year for the specified parameters. It can be used to plot
an ngram based on the words' presence in books in the library's collection.
}
\examples{
# Get ngram count for the words "hus" and "blokk" in the specified period
get_ngram_from_books(period = list(1990, 2000))

# Get ngram count for the word "library" in English books
get_ngram_from_books(lang = "eng", word = list("library"))
}
