% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latent_cor.R
\name{latent_cor}
\alias{latent_cor}
\title{Latent correlations}
\usage{
latent_cor(
  dataSrc,
  item_property,
  predicate = NULL,
  nDraws = 500,
  hpd = 0.95,
  use = "complete.obs"
)
}
\arguments{
\item{dataSrc}{A connection to a dexter database or a data.frame with columns: person_id, item_id, item_score and 
the item_property}

\item{item_property}{The name of the item property used to define the domains. If \code{dataSrc} is a dexter db then the
item_property must match a known item property. If dataSrc is a data.frame, item_property must be equal to
 one of its column names.}

\item{predicate}{An optional expression to subset data, if NULL all data is used}

\item{nDraws}{Number of draws for plausible values}

\item{hpd}{width of Bayesian highest posterior density interval around the correlations, 
value must be between 0 and 1.}

\item{use}{Only complete.obs at this time. Respondents who don't have a score for one or more scales are removed.}
}
\value{
List containing a estimated correlation matrix, the corresponding standard deviations, 
and the lower and upper limits of the highest posterior density interval and the complete mcmc sample
}
\description{
Estimates correlations between latent traits using plausible values as described in Marsman, et al. (2022). 
An item_property is used to distinguish the different scales.
}
\details{
This function uses plausible values so results may differ slightly between calls.
}
\references{
Marsman, M., Bechger, T. M., & Maris, G. K. (2022). Composition algorithms for conditional distributions. 
In Essays on Contemporary Psychometrics (pp. 219-250). Cham: Springer International Publishing.
}
