% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tree.R
\name{create_tree}
\alias{create_tree}
\title{Tree Construction from DEXi's XML Output}
\usage{
create_tree(main_tree, which_root = "all", correct = FALSE)
}
\arguments{
\item{main_tree}{A character or an object of class \code{XML}. Either the
path to the .dxi file containing the tree (character) or the XML object
that represents the primary tree structure and should encompass the DEXi
decision model.}

\item{which_root}{an integer to indicate which tree to create among several in a .dxi or "all" (default) to create them all.}

\item{correct}{A logical. If TRUE, use some correction function to avoid special character as " ' ".}
}
\value{
A list of \code{Tree} objects, each corresponding to a unique root
attribute in the DEXi XML layout. Each tree details the root attribute,
nodes, leaves, depth, and other associated data regarding the decision
model's configuration.
}
\description{
Constructs a \code{Tree} objects using the XML representation from a DEXi
model.
}
\details{
Iterates over every root attribute in the provided XML to create tree
structures that depict the hierarchical decision model.
}
\examples{
# With a Path
dxi_masc2_path <- system.file("extdata", "arborescence_MASC_2_0.dxi", package = "dexisensitivity")
tree <- create_tree(dxi_masc2_path)
tree

# With an XML
dxi_masc2_path <- system.file("extdata", "arborescence_MASC_2_0.dxi", package = "dexisensitivity")
masc2_xml <- XML::xmlDeserializeHook(dxi_masc2_path)
tree <- create_tree(masc2_xml)
tree

}
