% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stats.R
\name{Froh_inbreedingClass}
\alias{Froh_inbreedingClass}
\title{Function to calculated Froh using a ROH-class}
\usage{
Froh_inbreedingClass(runs, mapFile, Class = 2)
}
\arguments{
\item{runs}{R object (dataframe) with ROH results}

\item{mapFile}{Plink map file (for SNP position)}

\item{Class}{base ROH-length interval (in Mbps) (default: 0-2, 2-4, 4-8, 8-16, >16)}
}
\value{
A data frame with individual inbreeding coefficients based on ROH-length of
specific size. The sum of ROH-length of specific size in each individual is
reported alongside
}
\description{
This function calculates the individual inbreeding coefficients based on runs of
homozygosity (ROH) using only ROH of specific size classes.
The parameter \code{class} specify the size interval to split up calculations.
For example, if \code{class = 2} Froh based on ROH 0-2, 2-4, 4-8, 80-16, >16 Mbps long
will be calculated.
}
\examples{
# getting map and ped paths
genotypeFile <- system.file("extdata", "Kijas2016_Sheep_subset.ped", package = "detectRUNS")
mapFile <- system.file("extdata", "Kijas2016_Sheep_subset.map", package = "detectRUNS")

# calculating runs of Homozygosity
\dontrun{
# skipping runs calculation
runs <- slidingRUNS.run(genotypeFile, mapFile, windowSize = 15, threshold = 0.1,  minSNP = 15,
ROHet = FALSE,  maxOppositeGenotype = 1, maxMiss = 1,  minLengthBps = 100000,  minDensity = 1/10000)
}
# loading pre-calculated data
runsFile <- system.file("extdata", "Kijas2016_Sheep_subset.sliding.csv", package="detectRUNS")
runsDF <- readExternalRuns(inputFile = runsFile, program = 'detectRUNS')

Froh_inbreedingClass(runs = runsDF, mapFile = mapFile, Class = 2)

}
