% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{preprocess}
\alias{preprocess}
\title{Data preparation for changepoint detection using functions in this package..}
\usage{
preprocess(file = NULL,
header = NULL,
sep    = NULL,
signal = NULL,
noise = NULL,
butterfreq = NULL,
model = NULL)
}
\arguments{
\item{file}{a data matrix or file name with columns as variables and rows as observations across time.}

\item{header}{logical for whether or not there is a header in the data file.}

\item{sep}{The spacing of the data files.
"" indicates space-delimited,
"/t" indicates tab-delimited, "," indicates comma delimited. Only necessary
to specify if reading data in from physical directory.}

\item{signal}{(optional) a character vector containg the names of variables that contain signal i.e., which variables to use to detect change point. The default
(NULL) indicates all variables except those in 'noise' argument are considered signal. Example: signal = c("dDMN4", "vDMN5", "vDMN1",}

\item{noise}{(optional) a character vector containg the names of variables that contain noise. The signal variables will be regressed on these variables and residuals
used in change point detection. The deault (NULL) indicates there are no noise variables. Example: noise = c("White.Matter1", "CSF1")}

\item{butterfreq}{(optional) bandpass filter frequency ranges. Example: c(.04,.4)}

\item{model}{(optional) syntax indicating which variables belong to which networks for first pass of data reduction that is user-specified. If no header naming convention follows "V#". Notation should follow lavaan syntax style.}
}
\description{
Id
}
