\name{ols.predict}
\alias{ols.predict}
\title{Predictions in a Linear Model}
\usage{
ols.predict(mod, data = list(), xnew, antilog = FALSE, details = FALSE)
}
\arguments{
\item{mod}{model object generated by \code{ols()} or \code{lm()}.}

\item{data}{name of data frame to be specified if \code{mod} is a formula.}

\item{xnew}{(T x K) matrix of new values of the exogenous variables, for which a prediction should be made, where \code{K} is the number of exogenous variables in the model \code{T} is the number of predictions to be made. If \code{xnew} is not specified, the fitted values are returned.}

\item{antilog}{logical value which indicates whether to re-transform the predicted value of a log transformed dependent variable back into original units.}

\item{details}{logical value, if specified as \code{TRUE}, a list is returned, which additionally includes the estimated variance of the prediction error (\code{var.pe}), estimated variance of the error term (\code{sig.squ}), and the estimated sampling error (\code{smpl.err}).}
}
\value{
A list object including:
\tabular{ll}{
  \code{pred.val} \tab the predicted values.\cr
  \code{xnew} \tab values of predictor at which predictions should be evaluated.\cr
  \code{var.pe} \tab estimated variance of prediction error.\cr
  \code{sig.squ} \tab estimated variance of error term.\cr
  \code{smpl.err} \tab estimated sampling error.\cr
  \code{mod} \tab the model estimated (for internal purposes)\cr
}
}
\description{
Calculates the predicted values of a linear model based on specified values of the exogenous variables. Optionally the estimated variance of the prediction error is returned.
}
\examples{
## Estimate logarithmic model
fert.est <- ols(barley ~ phos + nit, data = log(data.fertilizer))

## Set new x data
my.mat = cbind(x1 = log(c(6,3,9)), x2 = log(c(5,3,10)))

## Returns fitted values
ols.predict(fert.est)

## Returns predicted values at new x-values
ols.predict(fert.est, xnew = my.mat)

## Returns re-transformed predicted values and est. var. of pred. error
ols.predict(fert.est, xnew = my.mat, antilog = TRUE, details = TRUE)

}
\concept{linear model}
\concept{predicted values}
