\name{plot.desk}
\alias{plot.desk}
\title{Simplified Plotting of Regression- and Test-results}
\usage{
\method{plot}{desk}(x, ...)
}
\arguments{
\item{x}{object of class desk to be plotted.}

\item{...}{any argument that \code{plot()} accepts.}
}
\description{
This function implements an S3 method for plotting regression- and test-results generated by functions of the desk package. Used for internal purposes.
}
\value{
No return value. Called for side effects.
}
\examples{
## Test H1: "phos + nit <> 1"
fert.est <- ols(barley ~ phos + nit, data = log(data.fertilizer))
x = par.t.test(fert.est, nh = c(0,1,1), q = 1, details = TRUE)
x # Show the test results
class(x) # Check its class
plot(x) # Visualize the test result

## Plot confidence (dark) and prediction bands (light), residuals and two center lines
## in a simple regression model
tip.est <- ols(y ~ x, data = data.tip)
class(x) # Check its class
plot(tip.est, pred.int = TRUE, conf.int = TRUE, residuals = TRUE, center = TRUE)
}
\concept{plot}
\concept{regression results}
\concept{test results}
