% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.naivedensityratio}
\alias{predict.naivedensityratio}
\title{Obtain predicted density ratio values from a \code{naivedensityratio} object}
\usage{
\method{predict}{naivedensityratio}(object, newdata = NULL, log = FALSE, tol = 1e-06, ...)
}
\arguments{
\item{object}{A \code{naive} object}

\item{newdata}{Optional \code{matrix} new data set to compute the density}

\item{log}{A logical indicating whether to return the log of the density ratio}

\item{tol}{Minimal density value to avoid numerical issues}

\item{...}{Additional arguments to be passed to the function}
}
\value{
An array with predicted density ratio values from possibly new data,
but otherwise the numerator samples.
}
\description{
Obtain predicted density ratio values from a \code{naivedensityratio} object
}
\examples{
set.seed(123)
# Fit model
dr <- naive(numerator_small, denominator_small)
# Inspect model object
dr
# Obtain summary of model object
summary(dr)
# Plot model object
plot(dr)
# Plot density ratio for each variable individually
plot_univariate(dr)
# Plot density ratio for each pair of variables
plot_bivariate(dr)
# Predict density ratio and inspect first 6 predictions
head(predict(dr))
# Fit model with custom parameters
naive(numerator_small, denominator_small, m=2, kernel="epanechnikov")
}
\seealso{
\code{\link{predict}}, \code{\link{naive}}
}
\keyword{naive}
\keyword{predict}
