% Generated by roxygen2 (4.0.1): do not edit by hand
\name{d3dendrogram}
\alias{d3dendrogram}
\title{Plot dendrogram to webpage and view.}
\usage{
d3dendrogram(d, height = 500, width = 700, rightmargin = 200,
  open = TRUE, ...)
}
\arguments{
\item{d}{a dendrogram object}

\item{height}{pixels, height of the plot.}

\item{width}{pixels, width of the plot}

\item{rightmargin}{pixels to reserve on the right side for leaf labels.}

\item{open}{open the graphic in a browser? (see details).}

\item{...}{Graphical options, see \code{\link{d3dendro_options}}.}
}
\value{
If \code{open=TRUE}, a character string containing the html is invisibly retured.
If \code{open=TRUE}, a character string containing the html is returned.
}
\description{
Plot dendrogram to webpage and view.
}
\details{
If \code{open=TRUE}, the graphic is opened using the function defined by \code{getOption("viewer")}.
If no \code{viewer} option is specified, \code{utils::browseURL} is opened. Specifically, in RStudio
this means that the viewer is used.
}
\section{Tips}{

Dendrogram plots with many end-nodes tend to get overlapping labels or (end)nodes. If the number of endnodes
is not too large, there are several ways to overcome this.
\itemize{
\item{Decrease font size of the nodes (\code{node_font}, see \code{\link{d3dendro_options}} on how to specify)}
\item{Decrease size of node radius (\code{node_radius}, \emph{idem})}
\item{Increase the height of the plot. Use about (2 times font height) times count_terminal_nodes(d).}
\item{Plot sub-dendrograms in stead of the whole dendrogram. There's only so much
  detail a screen can display and your eye can observe. Consider plotting subdendrograms or other summaries
  when dendrograms have many, many nodes.}
}
}

