% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trafo_ensembles.R
\name{trafoensemble}
\alias{trafoensemble}
\title{Transformation ensembles}
\usage{
trafoensemble(
  formula,
  data,
  n_ensemble = 5,
  verbose = FALSE,
  print_members = TRUE,
  stop_if_nan = TRUE,
  save_weights = TRUE,
  callbacks = list(),
  save_fun = NULL,
  seed = seq_len(n_ensemble),
  tf_seeds = seq_len(n_ensemble),
  ...
)
}
\arguments{
\item{formula}{Formula specifying the response, interaction, shift terms
as \code{response | interacting ~ shifting}.
auto-regressive transformation models (ATMs).}

\item{data}{Named \code{list} or \code{data.frame} which may contain both
structured and unstructured data.}

\item{n_ensemble}{Numeric; number of ensemble members to fit.}

\item{verbose}{Logical; whether to print training in each fold.}

\item{print_members}{Logical; print results for each member.}

\item{stop_if_nan}{Logical; whether to stop ensembling if \code{NaN} values
occur}

\item{save_weights}{Logical; whether to save the ensemble weights.}

\item{callbacks}{List; callbacks used for fitting.}

\item{save_fun}{Function; function to be applied to each member to be stored
in the final result.}

\item{seed}{Numeric vector of length \code{n_ensemble}; seeds for model
re-initialization. Changing these seeds does not change the  parameters
of the interacting predictor \code{coef(obj, which_param = "interacting")},
change \code{tf_seeds} to adapt those coefficients.}

\item{tf_seeds}{Numeric vector of length \code{n_ensemble}; explicit seed for
changing the parameters of the interacting predictor. Distinct from
\code{seed} which is used for weight re-initialization of the rest of the
model (i.e., the shifting predictor and potential neural network components
in the interacting component).}

\item{...}{Further arguments passed to \code{deeptrafo} and \code{fit}.}
}
\value{
Ensemble of \code{"deeptrafo"} models with list of training histories
    and fitted weights included in \code{ensemble_results}. For details see
    the return statment in \code{\link[deepregression]{ensemble}}.
}
\description{
Transformation ensembles
}
