% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.deepregression}
\alias{plot.deepregression}
\alias{predict.deepregression}
\alias{fitted.deepregression}
\alias{fit.deepregression}
\alias{coef.deepregression}
\alias{print.deepregression}
\alias{cv.deepregression}
\alias{mean.deepregression}
\alias{stddev.deepregression}
\alias{quant.deepregression}
\title{Generic functions for deepregression models}
\usage{
\method{plot}{deepregression}(
  x,
  which = NULL,
  which_param = 1,
  only_data = FALSE,
  grid_length = 40,
  type = "b",
  ...
)

\method{predict}{deepregression}(
  object,
  newdata = NULL,
  batch_size = NULL,
  apply_fun = tfd_mean,
  convert_fun = as.matrix,
  ...
)

\method{fitted}{deepregression}(object, apply_fun = tfd_mean, ...)

\method{fit}{deepregression}(
  object,
  batch_size = 32,
  epochs = 10,
  early_stopping = FALSE,
  early_stopping_metric = "val_loss",
  verbose = TRUE,
  view_metrics = FALSE,
  patience = 20,
  save_weights = FALSE,
  validation_data = NULL,
  validation_split = ifelse(is.null(validation_data), 0.1, 0),
  callbacks = list(),
  convertfun = function(x) tf$constant(x, dtype = "float32"),
  ...
)

\method{coef}{deepregression}(object, which_param = 1, type = NULL, ...)

\method{print}{deepregression}(x, ...)

\method{cv}{deepregression}(
  x,
  verbose = FALSE,
  patience = 20,
  plot = TRUE,
  print_folds = TRUE,
  cv_folds = 5,
  stop_if_nan = TRUE,
  mylapply = lapply,
  save_weights = FALSE,
  callbacks = list(),
  save_fun = NULL,
  ...
)

\method{mean}{deepregression}(x, data = NULL, ...)

\method{stddev}{deepregression}(x, data = NULL, ...)

\method{quant}{deepregression}(x, data = NULL, probs, ...)
}
\arguments{
\item{x}{a deepregression object}

\item{which}{character vector or number(s) identifying the effect to plot; 
default plots all effects}

\item{which_param}{integer, indicating for which distribution parameter
coefficients should be returned (default is first parameter)}

\item{only_data}{logical, if TRUE, only the data for plotting is returned}

\item{grid_length}{the length of an equidistant grid at which a two-dimensional function
is evaluated for plotting.}

\item{type}{either NULL (all types of coefficients are returned),
"linear" for linear coefficients or "smooth" for coefficients of 
smooth terms}

\item{...}{arguments passed to the \code{predict} function}

\item{object}{a deepregression model}

\item{newdata}{optional new data, either data.frame or list}

\item{batch_size}{integer, the batch size used for mini-batch training}

\item{apply_fun}{function applied to fitted distribution,
per default \code{tfd_mean}}

\item{convert_fun}{how should the resulting tensor be converted,
per default \code{as.matrix}}

\item{epochs}{integer, the number of epochs to fit the model}

\item{early_stopping}{logical, whether early stopping should be user.}

\item{early_stopping_metric}{character, based on which metric should
early stopping be trigged (default: "val_loss")}

\item{verbose}{whether to print training in each fold}

\item{view_metrics}{logical, whether to trigger the Viewer in RStudio / Browser.}

\item{patience}{number of patience for early stopping}

\item{save_weights}{logical, whether to save weights in each epoch.}

\item{validation_data}{optional specified validation data}

\item{validation_split}{float in [0,1] defining the amount of data used for validation}

\item{callbacks}{a list of callbacks used for fitting}

\item{convertfun}{function to convert R into Tensor object}

\item{plot}{whether to plot the resulting losses in each fold}

\item{print_folds}{whether to print the current fold}

\item{cv_folds}{an integer if list with train and test data sets}

\item{stop_if_nan}{logical; whether to stop CV if NaN values occur}

\item{mylapply}{lapply function to be used; defaults to \code{lapply}}

\item{save_fun}{function applied to the model in each fold to be stored in
the final result}

\item{data}{either \code{NULL} or a new data set}

\item{probs}{the quantile value(s)}
}
\value{
Returns an object \code{drCV}, a list, one list element for each fold
containing the model fit and the \code{weighthistory}.
}
\description{
Generic functions for deepregression models

Predict based on a deepregression object

Function to extract fitted distribution

Fit a deepregression model (pendant to fit for keras)

Extract layer weights / coefficients from model

Print function for deepregression model

Cross-validation for deepgression objects

mean of model fit

Standard deviation of fit distribution

Calculate the distribution quantiles
}
