% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pimp.R
\name{pimp}
\alias{pimp}
\title{Fix and improve texts using the official DeepL Translator API}
\usage{
pimp(text, help_lang, auth_key = "your_key")
}
\arguments{
\item{text}{text to be translated. Only UTF8-encoded plain text is supported. May contain multiple sentences.
The request size should not exceed 30kbytes.}

\item{help_lang}{language used as a help language for reverse translation. Can be one of the following:
\itemize{
\item \code{EN} English
\item \code{DE} German
\item \code{FR} French
\item \code{ES} Spanish
\item \code{IT} Italian
\item \code{NL} Dutch
\item \code{PL} Polish
 }}

\item{auth_key}{DeepL authentication key which provides access to the API.}
}
\description{
\code{pimp} translates a text into a help language and then back into the original language
    using the official DeepL Translator API. To use this service, an authentication key is required.
}
\examples{
\donttest{
pimp("In former times I lived in Zurich", help_lang = "DE", auth_key = "my_key")
}

}
