% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelfuzzy_guotanaka.R
\name{modelfuzzy_guotanaka}
\alias{modelfuzzy_guotanaka}
\title{Fuzzy DEA model}
\usage{
modelfuzzy_guotanaka(datadea,
                     dmu_eval = NULL,
                     dmu_ref = NULL,
                     orientation = c("io", "oo"),
                     h = 1)
}
\arguments{
\item{datadea}{A \code{deadata_fuzzy} object, including DMUs, inputs and outputs.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.
If \code{NULL} (default), all DMUs are considered.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation reference set.
If \code{NULL} (default), all DMUs are considered.}

\item{orientation}{A string, equal to "io" (input oriented) or "oo" (output oriented).}

\item{h}{A numeric vector with the h-levels (in [0,1]).}
}
\value{
A list of class \code{dea_fuzzy} with the results for the evaluated DMUs (\code{DMU} component,
we note that we call "targets" to the "efficient projections"
in the strongly efficient frontier),
 along with any other necessary information to replicate the results, such as
 the name of the model and parameters \code{orientation}, \code{h},
 \code{dmu_eval} and \code{dmu_ref}.
}
\description{
Solve the Fuzzy input-oriented and output-oriented DEA model proposed
by Guo and Tanaka (2001) under constant returns to scale. In deaR is implemented
the LP poblem given by the model (16) in Guo and Tanaka (2001, p.155). The fuzzy
efficiencies are calculated according to equations in (17) (Guo and Tanaka, 2001, p.155).
The (crisp) relative efficiencies and multipliers for the case \code{h} = 1 are
obtained from the CCR model (\code{model_multiplier}).
}
\note{
The optimal solution of model (16) is not unique.
}
\examples{
# Example 1.
# Replication results in Guo and Tanaka (2001, p. 159). 
# In deaR is implemented the LP poblem given by the model 16 in Guo and Tanaka (2001, p. 155).
# The fuzzy efficiencies are calculated according to equations in (17) (Guo and Tanaka, 2001,p.155).
data("Guo_Tanaka_2001")
data_example <- make_deadata_fuzzy(Guo_Tanaka_2001, 
                                   inputs.mL = 2:3, 
                                   inputs.dL = 4:5, 
                                   outputs.mL = 6:7,
                                   outputs.dL = 8:9)
result <- modelfuzzy_guotanaka(data_example, 
                               h = c(0, 0.5, 0.75, 1), 
                               orientation = "io")
efficiencies(result)
 
# Example 2. 
data("Guo_Tanaka_2001")
data_example <- make_deadata_fuzzy(Guo_Tanaka_2001, 
                                   inputs.mL = 2:3, 
                                   inputs.dL = 4:5, 
                                   outputs.mL = 6:7, 
                                   outputs.dL = 8:9)
result2 <- modelfuzzy_guotanaka(data_example, 
                                h = seq(0, 1, by = 0.1), 
                                orientation = "io")
efficiencies(result2)

}
\references{
Emrouznejad, A.; Tavana, M.; Hatami-Marbini, A. (2014). “The State of the Art
in Fuzzy Data Envelopment Analysis”, in A. Emrouznejad and M. Tavana (eds.),
Performance Measurement with Fuzzy Data Envelopment Analysis. Studies in Fuzziness
and Soft Computing 309. Springer, Berlin. \doi{10.1007/978-3-642-41372-8_1}

Guo, P.; Tanaka, H. (2001). "Fuzzy DEA: A Perceptual Evaluation Method", Fuzzy
Sets and Systems, 119, 149–160. \doi{10.1016/S0165-0114(99)00106-2}

Hatami-Marbini, A.; Emrouznejad, A.; Tavana, M. (2011). "A Taxonomy and Review
of the Fuzzy Data Envelopment Analysis Literature: Two Decades in the Making",
European Journal of Operational Research, 214, 457–472. \doi{10.1016/j.ejor.2011.02.001}
}
\seealso{
\code{\link{model_basic}}, \code{\link{model_multiplier}},
\code{\link{modelfuzzy_kaoliu}}, \code{\link{modelfuzzy_possibilistic}},
\code{\link{cross_efficiency_fuzzy}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
