% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maximal_friends.R
\name{maximal_friends}
\alias{maximal_friends}
\title{Maximal friends of a set of DMUs.}
\usage{
maximal_friends(datadea,
             dmu_ref = NULL,
             rts = c("crs", "vrs", "nirs", "ndrs"),
             tol = 1e-6,
             silent = FALSE)
}
\arguments{
\item{datadea}{The data, including \code{n} DMUs, \code{m} inputs and \code{s} outputs.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation reference set,
i.e. the cluster of DMUs from which we want to find maximal friends.
If \code{NULL} (default), all DMUs are considered.}

\item{rts}{A string, determining the type of returns to scale, equal to "crs" (constant),
"vrs" (variable), "nirs" (non-increasing) or "ndrs" (non-decreasing).}

\item{tol}{Numeric, a tolerance margin for checking efficiency. It is 1e-6 by default.}

\item{silent}{Logical, if \code{FALSE} (default) steps are printed.}
}
\value{
A list with numeric vectors representing maximal friends subsets of DMUs.
}
\description{
Finds the maximal friends subsets of a given set of DMUs, according to Tone (2010).
             It uses a descending algorithm in order to find directly maximal subsets.
}
\examples{
\dontrun{
data("PFT1981")
datadea <- read_data(PFT1981, ni = 5, no = 3)
# We find maximal friends of a cluster formed by the first 20 DMUs
result <- maximal_friends(datadea = datadea,
                          dmu_ref = 1:20)
}
 
}
\references{
Tone, K. (2010). "Variations on the theme of slacks-based measure of efficiency in DEA",
European Journal of Operational Research, 200, 901-907. \doi{10.1016/j.ejor.2009.01.027}
}
\seealso{
\code{\link{is.friends}}, \code{\link{model_sbmeff}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
