% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate-extend.R
\name{parent_plate_type}
\alias{parent_plate_type}
\title{Parent plate type}
\usage{
parent_plate_type(plate)
}
\arguments{
\item{plate}{A ddPCR plate}
}
\value{
The parent type of the given plate.
}
\description{
Each ddPCR plate has a "parent" plate type from which it inherits all its 
properties. When creating a custom plate type, if your plate type inherits from
any plate type other than the base type of \code{ddpcr_plate}, you must define
this function to return the parent plate type. Inheriting
from a parent plate means that the same cluster types, analysis steps, and
parameters will be used by default.
}
\details{
\href{https://github.com/daattali/ddpcr#advanced-topic-3-creating-new-plate-types}{See the README} for more
information on plate types.
}
\seealso{
\code{\link[ddpcr]{type}}\cr
\code{\link[ddpcr]{define_params}}\cr
\code{\link[ddpcr]{define_clusters}}\cr
\code{\link[ddpcr]{define_steps}}
}
\keyword{internal}
