% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ddpcr_plate}
\alias{plot.ddpcr_plate}
\title{Plot a ddPCR plate}
\usage{
\method{plot}{ddpcr_plate}(x, wells, samples, superimpose = FALSE,
  show_full_plate = FALSE, show_drops = TRUE, show_drops_empty = FALSE,
  show_drops_outlier = FALSE, show_failed_wells = TRUE,
  col_drops = "black", col_drops_undefined = col_drops,
  col_drops_failed = col_drops, col_drops_empty = col_drops,
  col_drops_outlier = "orange", bg_plot = "transparent",
  bg_failed = "#111111", bg_unused = "#FFFFFF", alpha_drops = 0.2,
  alpha_drops_outlier = 1, alpha_bg_failed = 0.7, xlab = x_var(plate),
  ylab = y_var(plate), title = NULL, show_grid = FALSE,
  show_grid_labels = FALSE, drops_size = 1, text_size_title = 14,
  text_size_row_col = 12, text_size_axes_labels = 12,
  text_size_grid_labels = 12, ...)
}
\arguments{
\item{x}{A ddPCR plate.}

\item{wells}{Only plot selected wells. Supports range notation, see
\code{\link[ddpcr]{subset.ddpcr_plate}}.}

\item{samples}{Only plot selected samples.}

\item{superimpose}{If \code{TRUE}, show all wells superimposed in one plot;
otherwise, show wells in a grid.}

\item{show_full_plate}{If \code{TRUE}, show full 96-well plate; otherwise,
show only plate rows and columns that are used.}

\item{show_drops}{Whether or not to show the droplets. Setting to \code{FALSE}
is not useful if the droplets are the only thing shown in the plot, but it
can be useful if there is other information depicated in the plot, such as
any background colours or text that may appear in each well.}

\item{show_drops_empty}{Whether or not to show the droplets defined as empty.
See 'Droplet visibility options' below.}

\item{show_drops_outlier}{Whether or not to show the droplets defined as
outliers. See 'Droplet visibility options' below.}

\item{show_failed_wells}{Whether or not to include wells that are deemed
as failed ddPCR runs.}

\item{col_drops}{The default colour to use for any droplet.}

\item{col_drops_undefined}{The colour to use for droplets that have not been
analyzed yet. See 'Droplet visibility options' below.}

\item{col_drops_failed}{The colour to use for droplets in failed wells.
See 'Droplet visibility options' below.}

\item{col_drops_empty}{The colour to use for empty droplets.
See 'Droplet visibility options' below.}

\item{col_drops_outlier}{The colour to use for outlier droplets.
See 'Droplet visibility options' below.}

\item{bg_plot}{The background colour for the plot.}

\item{bg_failed}{The background colour to use for failed wells.}

\item{bg_unused}{The background colour to use for unused wells.}

\item{alpha_drops}{The transparency of droplets.}

\item{alpha_drops_outlier}{The transparency of outlier droplets.
See 'Droplet visibility options' below.}

\item{alpha_bg_failed}{The transparency of the background of failed wells.}

\item{xlab}{The label on the X axis.}

\item{ylab}{The label on the Y axis.}

\item{title}{The title for the plot.}

\item{show_grid}{Whether or not to show grid lines.}

\item{show_grid_labels}{Whether or not to show numeric labels for the grid
lines along the axes.}

\item{drops_size}{Size of droplets.}

\item{text_size_title}{Text size of the title.}

\item{text_size_row_col}{Text size of the row and column labels.}

\item{text_size_axes_labels}{Text size of the X/Y axis labels.}

\item{text_size_grid_labels}{Text size of the numeric grid line labels.}

\item{...}{Ignored.}
}
\value{
A ggplot2 plot object.
}
\description{
Plot the data of a ddPCR plate. A plate can be plotted throughout any stage
of the analysis, and the most up-to-date data will be shown. For example,
a plot performed after initializing a plat will show all the raw data, but
a plot performed after analyzing a plate will show information such as
empty drops and failed wells.
}
\section{Droplet visibility options}{

To make it easier to support any plate type with any types of droplet
clusters, there are three categories of special parameters that can always
be used:

\itemize{
  \item{\code{show_drops_*}}{ Whether or not to show a specific group of
  droplets.}
  \item{\code{col_drops_*}}{ What colour to use for a specific group of
  droplets.}
  \item{\code{alpha_drops_*}}{ What transparency to use for a specific group
  of droplets.}
}

The \code{*} in the parameter name can be replaced by the name of any
droplet cluster. Use the \code{\link[ddpcr]{clusters}} function to 
find out what clusters the droplets in a plate can be assigned to.

For example, the default clusters that exist in a plain \code{ddpcr_plate}
are "UNDEFINED", "FAILED", "OUTLIER", and "EMPTY".  This means that if you
want to hide the empty drops and make the transparency of drops in failed
wells 0.5, you could add the two parameters \code{show_drops_empty = FALSE}
and \code{alpha_drops_failed = 0.5}. Note that letter case is not important.
If another plate type defines a new clsuter of type "MUTANT" and you want to
show these drops in red, you can add the parameter
\code{col_drops_mutant = "red"}.

Note that some of the more common combinations of these parameters are
defined by default (for example, \code{col_drops_failed} is defined in the
list of parameters), but these three parameter categories will work for
any cluster type.
}

\section{Extending ddpcr_plate}{

If you create your own plate type, this default plot function might be
enough if there is no extra information you want to display in a plot.
If you do need to provide a more customized plot function, it can be
a good idea to use the output from this plot function as a basis and only
add the code that is necessary to append to the plot.  See
\code{\link[ddpcr]{plot.custom_thresholds}} as an example of how to
extend this plot function.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir())
plot(plate)
plate <- plate \%>\% analyze
plot(plate)
plot(plate, "B01:C06", show_drops_empty = TRUE, col_drops_empty = "red")
}
}

