% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVuncertain.R
\name{IVuncertain}
\alias{IVuncertain}
\title{Uncertainty for IV feature extraction}
\usage{
IVuncertain(dat, crt = 0.2, num = 75, crtvalb = 0.3, iter = 1000,
  plot.option = F)
}
\arguments{
\item{dat}{A dataframe of IV curve. The variable names should be "V" for voltage, and "I" for current. And rank with increasing voltage.}

\item{crt}{a value to set for how large of regression coefficient change rate we use as not changing much. Should be the same as using function "IVExtractResult". Default is 0.6.}

\item{num}{a value of number of data points. The default is 25.}

\item{crtvalb}{a value to set the change of I(current) we want to use as changing very much (to detect the end of IV curve). Suggestion is to test this function with several IV curves for your data and find the proper value. The default is 0.3}

\item{iter}{number of iterations want to use to calculate uncertainty. Default is 1000, takes about 20 minutes to finish calculation.}

\item{plot.option}{True/False, it plots the IV curve. The default is false.}
}
\value{
a list of the following items:
\itemize{
 \item "unct_Isc": uncertainty for short-circuit current, the number of variables is decided by the number of steps.
 \item "unct_Rsh": uncertainty for shunt resistance, the number of variables is decided by the number of steps.
 \item "unct_Voc": uncertainty for open-circuit voltage, the number of variables is decided by the number of steps.
 \item "unct_Rs": uncertainty for series resistance, the number of variables is decided by the number of steps.
 \item "unct_Pmp": uncertainty for maximum power for a solar cell/PV module, the number of variables is decided by the number of steps.
 \item "unct_Imp": uncertainty for current at maximum power, the number of variables is decided by the number of steps.
 \item "unct_Vmp": uncertainty for voltage at maximum power, the number of variables is decided by the number of steps.
 \item "unct_FF": uncertainty for fill factor, the number of variables is decided by the number of steps.
 \item "unct_Cutoff": uncertainty for change point indicating steps. NA means that the IV curve has only one step and there is no change points.
}
}
\description{
Calculate the uncertainty of this data driven IV feature extraction
}
\examples{
#this IV curve is of step=1
data(IV_step1)
IV1 <- data.frame(IV_step1)
\donttest{IVuncertain(IV1)}

}
