% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{save_flobs}
\alias{save_flobs}
\title{Save flobs.}
\usage{
save_flobs(column_name, table_name, conn, dir = ".", sep = "_-_")
}
\arguments{
\item{column_name}{A string of the name of the BLOB column.}

\item{table_name}{A string of the name of the existing table.}

\item{conn}{A SQLite connection object.}

\item{dir}{A string of the path to the directory to save the files in.}

\item{sep}{A string of the separator used to construct file names from values.}
}
\value{
An invisible named vector of the file names and new file names saved.
}
\description{
Rename \code{\link[flobr]{flob}}s from a SQLite database BLOB column and save to directory.
}
\examples{
flob <- flobr::flob_obj
conn <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
DBI::dbGetQuery(conn, "CREATE TABLE Table1 (IntColumn INTEGER PRIMARY KEY NOT NULL)")
DBI::dbWriteTable(conn, "Table1", data.frame(IntColumn = c(1L, 2L)), append = TRUE)
key <- data.frame(IntColumn = 2L)
write_flob(flob, "BlobColumn", "Table1", key, conn, exists = FALSE)
dir <- tempdir()
save_flobs("BlobColumn", "Table1", conn, dir)
DBI::dbDisconnect(conn)
}
