% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbcsp.R
\name{boxplot.dbcsp}
\alias{boxplot.dbcsp}
\title{Boxplot for dbcsp object}
\usage{
\method{boxplot}{dbcsp}(x, vectors=1, pairs=TRUE, ordered_pairs=TRUE, show_log=TRUE, ...)
}
\arguments{
\item{x}{object of class \code{\link[=dbcsp-class]{dbcsp}}.}

\item{vectors}{integer or array of integers, indicating the index of the projected vectors to plot, by default \code{vectors=1}.}

\item{pairs}{logical, if TRUE the pairs of the indicated vectors are also shown, by default \code{pairs=TRUE}.}

\item{ordered_pairs}{logical, if TRUE the pairs are plotted next to each other, else pairs are plotted at the end, by default \code{ordered_pairs=TRUE}.}

\item{show_log}{logical, if TRUE the logarithms of the variances are displayed, else the variances are displayed, by default \code{show_log=TRUE}.}

\item{...}{optional arguments inherited from the generic \code{\link{boxplot}} method.}
}
\value{
Displays the boxplot of the variances of the selected vectors.
}
\description{
This function plots the variance of the selected vectors in a boxplot.
}
\details{
A boxplot with the variances of the selected vectors.
Vectors values must lie between 1 and 2*q, being q the number of dimensions used to perform the DB-CSP
algorithm when creating the \code{\link[=dbcsp-class]{dbcsp}} object. The following should be
taken into account when plotting:
\itemize{
\item The first q values (1,...,q) are indicated as a1...aq
\item The last q values (q+1,...,2*q) are indicated as b1...bq.
}

If \code{pairs=TRUE}, it is recommended that \code{vectors<q} for better understanding,
since their pairs are plotted as well. In case that \code{vectors>q}, it should be noted
that the values are displayed from b1 to bq, where b1 and bq represent q+1 vector and 2*q vector,
respectively.

For example if \code{q=15} and \code{boxplot(object, vectors=16, pairs=FALSE)}, b1 (16-q=1) vector is
shown.
}
\examples{
# Read data from 2 classes
x <- AR.data$come
y <- AR.data$five
mydbcsp <- new("dbcsp", X1 = x, X2 = y)
boxplot(mydbcsp)
boxplot(mydbcsp,vectors=1:4,pairs=FALSE)
boxplot(mydbcsp, vectors=c(1,4,7),ordered_pairs=FALSE)
}
\seealso{
\code{\link[=dbcsp-class]{dbcsp}}, \code{\link[=print.dbcsp]{print}}, \code{\link[=summary.dbcsp]{summary}}, \code{\link{train}}, \code{\link{selectQ}}, \code{\link[=predict.dbcsp]{predict}}, \code{\link[=plot.dbcsp]{plot}}
}
