% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_check.R
\name{type_check}
\alias{type_check}
\title{Type Check}
\usage{
type_check(DD.dict, verbose = TRUE)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{verbose}{When TRUE, the function prints the Message out, as well as more detailed diagnostic information.}
}
\value{
Tibble, returned invisibly, containing: (1) Time (Time stamp); (2) Name (Name of the function); (3) Status (Passed/Failed); (4) Message (A copy of the message the function printed out); (5) Information (List of illegal TYPE entries).
}
\description{
If a TYPE field exists, this function checks for any TYPE entries that aren't allowable per dbGaP instructions.
}
\details{
Allowable entries in TYPE column include: integer; decimal; encoded value; or string. For mixed values, list all types present using commas to separate (e.g., integer, encoded value).
}
\examples{
data(ExampleB)
type_check(DD.dict.B)
print(type_check(DD.dict.B, verbose=FALSE))
}
