% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife_query2.R
\name{make_datelife_query2}
\alias{make_datelife_query2}
\title{Go from taxon names to a \code{datelifeQuery} object}
\usage{
make_datelife_query2(
  input = c("Rhea americana", "Pterocnemia pennata", "Struthio camelus"),
  get_spp_from_taxon = FALSE,
  reference_taxonomy = "ott",
  ...
)
}
\arguments{
\item{input}{Taxon names as one of the following:
\describe{
\item{A character vector of taxon names}{With taxon names as a single comma separated starting or concatenated with \code{\link[=c]{c()}}.}
\item{A phylogenetic tree with taxon names as tip labels}{As a \code{phylo} or \code{multiPhylo}
object, OR as a newick character string.}
}}

\item{get_spp_from_taxon}{Whether to search ages for all species belonging to a
given taxon or not. Default to \code{FALSE}. If \code{TRUE}, it must have same length as input.
If input is a newick string with some clades it will be converted to a \code{phylo}
object, and the order of \code{get_spp_from_taxon} will match \code{phy$tip.label}.}

\item{reference_taxonomy}{A character vector specifying the reference taxonomy to use for TNRS.
Options are "ott", "ncbi", "gbif" or "irmng". The function defaults to "ott".}

\item{...}{
  Arguments passed on to \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names}}
  \describe{
    \item{\code{context_name}}{name of the taxonomic context to be searched (length-one
character vector or \code{NULL}). Must match (case sensitive) one of the
values returned by \code{\link[rotl]{tnrs_contexts}}. Default to "All life".}
    \item{\code{do_approximate_matching}}{A logical indicating whether or not to
perform approximate string (a.k.a. \dQuote{fuzzy}) matching. Using
\code{FALSE} will greatly improve speed. Default, however, is \code{TRUE}.}
    \item{\code{ids}}{A vector of ids to use for identifying names. These will be
assigned to each name in the names array. If ids is provided, then ids and
names must be identical in length.}
    \item{\code{include_suppressed}}{Ordinarily, some quasi-taxa, such as incertae
sedis buckets and other non-OTUs, are suppressed from TNRS results. If
this parameter is true, these quasi-taxa are allowed as possible TNRS
results.}
  }}
}
\value{
A \code{datelifeQuery} object, which is a list of four elements:
\describe{
\item{$input_names}{A character vector of input taxon names.}
\item{$tnrs_names}{A character vector of taxon names processed with TNRS.}
\item{$ott_ids}{A numeric vector of OTT ids.}
\item{$phy}{A \code{phylo} object or \code{NA}, if input is not a tree.}
}
}
\description{
Go from taxon names to a \code{datelifeQuery} object
}
\details{
It processes \code{phylo} objects and newick character string inputs
with \code{\link[=input_process]{input_process()}}. If \code{input} is a \code{multiPhylo} object, only the first \code{phylo}
element will be used. Similarly, if an \code{input} newick character string has multiple trees,
only the first one will be used.
}
