% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degrad.R
\encoding{UTF-8}
\name{load_degrad}
\alias{load_degrad}
\title{Degrad - Forest Degradation in the Brazilian Amazon}
\usage{
load_degrad(dataset = "degrad", raw_data, time_period, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("degrad").}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{time_period}{A \code{numeric} indicating what years will the data be loaded in the format YYYY. Can be a sequence of numbers such as 2010:2012.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported. Defaults to "eng".}
}
\value{
A \code{list} (if \code{raw_data} = \code{TRUE}) or a tibble (if \code{raw_data} = \code{FALSE}) with the selected data.
}
\description{
Loads information on forest degradation in the Brazilian Amazon, replaced by DETER-B in December 2016. Data is available from 2007 to 2016. See \url{http://www.obt.inpe.br/OBT/assuntos/programas/amazonia/degrad}.
}
\examples{
\dontrun{
# download raw data (raw_data = TRUE) related to forest degradation
# from 2010 to 2012 (time_period = 2010:2012).
data <- load_degrad(dataset = 'degrad',
                    raw_data = TRUE,
                    time_period = 2010:2012)

# download treated data (raw_data = FALSE) related to forest degradation
# from 2013 (time_period = 2013) in portuguese (language = "pt").
data <- load_degrad(dataset = 'degrad',
                    raw_data = FALSE,
                    time_period = 2013,
                    language = 'pt')
}

}
