% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_reshape.R
\name{data_to_long}
\alias{data_to_long}
\alias{data_to_wide}
\alias{reshape_longer}
\alias{reshape_wider}
\title{Reshape (pivot) data from wide to long}
\usage{
data_to_long(
  data,
  cols = "all",
  colnames_to = "Name",
  values_to = "Value",
  rows_to = NULL,
  ...,
  names_to = colnames_to
)

data_to_wide(
  data,
  values_from = "Value",
  colnames_from = "Name",
  rows_from = NULL,
  sep = "_",
  ...,
  names_from = colnames_from
)

reshape_longer(
  data,
  cols = "all",
  colnames_to = "Name",
  values_to = "Value",
  rows_to = NULL,
  ...,
  names_to = colnames_to
)

reshape_wider(
  data,
  values_from = "Value",
  colnames_from = "Name",
  rows_from = NULL,
  sep = "_",
  ...,
  names_from = colnames_from
)
}
\arguments{
\item{data}{A data frame to pivot.}

\item{cols}{A vector of column names or indices to pivot into longer format.}

\item{colnames_to}{The name of the new column that will contain the column
names.}

\item{values_to}{The name of the new column that will contain the values of
the pivoted variables.}

\item{rows_to}{The name of the column that will contain the row-number from
the original data. If \code{NULL}, will be removed.}

\item{...}{Additional arguments passed on to methods.}

\item{names_to, names_from}{Same as \code{colnames_to}, is there for
compatibility with \code{tidyr::pivot_longer()}.}

\item{values_from}{The name of the column that contains the values of the put
in the columns.}

\item{colnames_from}{The name of the column that contains the levels to be
used as future columns.}

\item{rows_from}{The name of the column that identifies the rows. If
\code{NULL}, will use all the unique rows.}

\item{sep}{The indicating a separating character in the variable names in the
wide format.}
}
\value{
data.frame
}
\description{
This function "lengthens" data, increasing the number of rows and decreasing
the number of columns. This is a dependency-free base-R equivalent of
\code{tidyr::pivot_longer()}.
}
\examples{
wide_data <- data.frame(replicate(5, rnorm(10)))

# From wide to long
# ------------------
# Default behaviour (equivalent to tidyr::pivot_longer(wide_data, cols = 1:5))
data_to_long(wide_data)

# Customizing the names
data_to_long(wide_data,
  cols = c(1, 2),
  colnames_to = "Column",
  values_to = "Numbers",
  rows_to = "Row"
)

# From long to wide
# -----------------
long_data <- data_to_long(wide_data, rows_to = "Row_ID") # Save row number
data_to_wide(long_data,
  colnames_from = "Name",
  values_from = "Value",
  rows_from = "Row_ID"
)

# Full example
# ------------------
if (require("psych")) {
  data <- psych::bfi # Wide format with one row per participant's personality test

  # Pivot long format
  long <- data_to_long(data,
    cols = "\\\\d", # Select all columns that contain a digit
    colnames_to = "Item",
    values_to = "Score",
    rows_to = "Participant"
  )

  # Separate facet and question number
  long$Facet <- gsub("\\\\d", "", long$Item)
  long$Item <- gsub("[A-Z]", "", long$Item)
  long$Item <- paste0("I", long$Item)

  wide <- data_to_wide(long,
    colnames_from = "Item",
    values_from = "Score"
  )
  head(wide)
}
}
