% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_data.R
\name{check_data}
\alias{check_data}
\title{Checks if a dataset confirms to a given set of rules}
\usage{
check_data(x, rules, fail_on_warn = FALSE, fail_on_error = FALSE)
}
\arguments{
\item{x}{a dataset, either a \code{\link{data.frame}}, \code{\link[dplyr:reexports]{dplyr::tibble}}, \code{\link[data.table:data.table]{data.table::data.table}},
\code{\link[arrow:Table]{arrow::arrow_table}}, \code{\link[arrow:open_dataset]{arrow::open_dataset}}, or \code{\link[dplyr:tbl]{dplyr::tbl}} (SQL connection)}

\item{rules}{a list of \code{\link{rule}}s}

\item{fail_on_warn}{if the function should throw an error on a warning}

\item{fail_on_error}{if the function should throw an error on a failed rule}
}
\value{
a data.frame-like object with one row for each rule and its results
}
\description{
Checks if a dataset confirms to a given set of rules
}
\examples{
rs <- ruleset(
  rule(mpg > 10),
  rule(cyl \%in\% c(4, 6)), # missing 8
  rule(qsec >= 14.5 & qsec <= 22.9)
)
rs

check_data(mtcars, rs)
}
