% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiSeries.R
\name{GetMultiSeriesProperties}
\alias{GetMultiSeriesProperties}
\title{Retrieve time series properties for a potential multiseries datetime partition column}
\usage{
GetMultiSeriesProperties(
  project,
  dateColumn,
  multiseriesIdColumns,
  crossSeriesGroupByColumns = NULL,
  maxWait = 600
)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{dateColumn}{character. The name of the column containing the date that defines the
time series.}

\item{multiseriesIdColumns}{character. Optional. The Series ID to demarcate the series. If
not specified, DataRobot will attempt to automatically infer the series ID.}

\item{crossSeriesGroupByColumns}{character. Optional. Column to split a cross series into
further groups. For example, if every series is sales of an individual product, the cross
series group could be e product category with values like "men's clothing", "sports
equipment", etc. Requires multiseries with \code{useCrossSeries} enabled.}

\item{maxWait}{integer. if a multiseries detection task is run, the maximum amount of time to
wait for it to complete before giving up.}
}
\value{
A named list which contains:
\itemize{
  \item timeSeriesEligible logical. Whether or not the series is eligible to be used for
    time series.
  \item crossSeriesEligible logical. Whether or not the cross series group by column is
    eligible for cross-series modeling. Will be NULL if no cross series group by column
    is used.
  \item crossSeriesEligibilityReason character. The type of cross series eligibility
    (or ineligibility).
  \item timeUnit character. For time series eligible features, the time unit covered by a
    single time step, e.g. "HOUR", or NULL for features that are not time series eligible.
  \item timeStep integer. Expected difference in time units between rows in the data.
    Will be NULL for features that are not time series eligible.
}
}
\description{
Multiseries time series projects use multiseries id columns to model multiple distinct
series within a single project. This function returns the time series properties
(time step and time unit) of this column if it were used as a datetime partition column
with the specified multiseries id columns, running multiseries detection automatically if
it had not previously been successfully ran.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  GetMultiSeriesProperties(projectId,
                           dateColumn = "myFeature",
                           multiseriesIdColumns = "Store")
}
}
