% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelRecommendations.R
\name{GetModelRecommendation}
\alias{GetModelRecommendation}
\title{Retrieve a model recommendation from DataRobot for your project.}
\usage{
GetModelRecommendation(project, type = RecommendedModelType$FastAccurate)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{type}{character. The type of recommendation to retrieve. See
\code{RecommendedModelType} for available options. Defaults to
\code{RecommendedModelType$FastAccurate}.}
}
\value{
A list containing information about the recommended model:
\itemize{
  \item modelId character. The model ID of the recommended model.
  \item projectId character. The project ID of the project the recommendations were made for.
  \item recommendationType character. The type of recommendation being made.
}
}
\description{
Model recommendations are only generated when you run full Autopilot. One of them
(the most accurate individual, non-blender model) will be prepared for deployment.
In the preparation process, DataRobot will: (1) calculate feature impact for the selected
model and use it to generate a reduced feature list, (2) retrain the selected model on the
reduced featurelist, (3) will replace the recommended model with the new model if
performance is improved on the reduced featurelist, (4) will retrain the model on a higher
sample size, and (5) will replace the recommended model with the higher sample size model if
it is more accurate.
}
\examples{
\dontrun{
  projectId <- "5984b4d7100d2b31c1166529"
  GetModelRecommendation(projectId)
}
}
