% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_part_vars_structure.R
\name{int_part_vars_structure}
\alias{int_part_vars_structure}
\title{Detect Expected Observations}
\usage{
int_part_vars_structure(
  study_data,
  meta_data,
  label_col = LABEL,
  expected_observations = c("HIERARCHY", "SEGMENT"),
  disclose_problem_paprt_var_data = FALSE
)
}
\arguments{
\item{study_data}{\link{study_data} must have all relevant \code{PART_VARS} to avoid
false-positives on \code{PART_VARS} missing from
\code{study_data}}

\item{meta_data}{\link{meta_data} must be complete to avoid false positives on
non-existing \code{PART_VARS}}

\item{label_col}{\link{character} mapping attribute \code{colnames(study_data)} vs.
\code{meta_data[label_col]}}

\item{expected_observations}{\link{enum} HIERARCHY | SEGMENT. How should
\code{PART_VARS} be handled:
- \code{SEGMENT}: if \code{PART_VAR} is 1, an
observation is expected
- \code{HIERARCHY}: the default, if the
\code{PART_VAR} is 1 for this variable and
also for all \code{PART_VARS} of \code{PART_VARS}
up in the hierarchy, an observation is
expected.}

\item{disclose_problem_paprt_var_data}{\link{logical} show the problematic data
(\code{PART_VAR} only)}
}
\value{
empty list, so far -- the function only warns.
}
\description{
For each participant, check, if an observation was expected, given the
\code{PART_VARS} from item-level metadata
}
