% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.ReportSummaryTable.R
\name{print.ReportSummaryTable}
\alias{print.ReportSummaryTable}
\title{print implementation for the class \code{ReportSummaryTable}}
\usage{
\method{print}{ReportSummaryTable}(x, relative, dt = FALSE, fillContainer = FALSE, ...)
}
\arguments{
\item{x}{an object used to select a method.}

\item{relative}{\link{logical} normalize the values in each column by
division by the \code{N} column.}

\item{dt}{\link{logical} use \code{DT::datatables}, if installed}

\item{fillContainer}{\link{logical} if \code{dt} is \code{TRUE}, control table size,
see \code{DT::datatables}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
the printed object
}
\description{
Use this function to print results objects of the class
\code{ReportSummaryTable}.
}
\details{
The default method, \code{\link[base]{print.default}} has its own help page.
  Use \code{\link{methods}("print")} to get all the methods for the
  \code{print} generic.

  \code{print.factor} allows some customization and is used for printing
  \code{\link[base]{ordered}} factors as well.

  \code{print.table} for printing \code{\link[base]{table}}s allows other
  customization.  As of R 3.0.0, it only prints a description in case of a table
  with 0-extents (this can happen if a classifier has no valid data).

  See \code{\link[base]{noquote}} as an example of a class whose main
  purpose is a specific \code{print} method.
}
\examples{
require(stats)

ts(1:20)  #-- print is the "Default function" --> print.ts(.) is called
for(i in 1:3) print(1:i)

## Printing of factors
attenu$station ## 117 levels -> 'max.levels' depending on width

## ordered factors: levels  "l1 < l2 < .."
esoph$agegp[1:12]
esoph$alcgp[1:12]

## Printing of sparse (contingency) tables
set.seed(521)
t1 <- round(abs(rt(200, df = 1.8)))
t2 <- round(abs(rt(200, df = 1.4)))
table(t1, t2) # simple
print(table(t1, t2), zero.print = ".") # nicer to read

## same for non-integer "table":
T <- table(t2,t1)
T <- T * (1+round(rlnorm(length(T)))/4)
print(T, zero.print = ".") # quite nicer,
print.table(T[,2:8] * 1e9, digits=3, zero.print = ".")
## still slightly inferior to  Matrix::Matrix(T)  for larger T

## Corner cases with empty extents:
table(1, NA) # < table of extent 1 x 0 >
}
\references{
Chambers, J. M. and Hastie, T. J. (1992)
  \emph{Statistical Models in S.}
  Wadsworth & Brooks/Cole.
}
\seealso{
The default method \code{\link[base]{print.default}}, and help for the
  methods above; further \code{\link[base]{options}}, \code{\link[base]{noquote}}.

  For more customizable (but cumbersome) printing, see
  \code{\link[base]{cat}}, \code{\link[base]{format}} or also \code{\link[base]{write}}.
  For a simple prototypical print method, see
  \code{\link[tools:print.via.format]{.print.via.format}} in package \pkg{tools}.
}
