% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_par_pmap.R
\name{util_par_pmap}
\alias{util_par_pmap}
\title{Utility function parallel version of \code{\link[purrr:map2]{purrr::pmap}}}
\usage{
util_par_pmap(
  .l,
  .f,
  ...,
  cores = list(mode = "socket", logging = FALSE, load.balancing = TRUE),
  use_cache = FALSE
)
}
\arguments{
\item{.l}{\link{data.frame} with one call per line and one function argument
per column}

\item{.f}{\code{\link{function}} to call with the arguments from \code{.l}}

\item{...}{additional, static arguments for calling \code{.f}}

\item{cores}{number of cpu cores to use or a (named) list with arguments for
\link[parallelMap:parallelStart]{parallelMap::parallelStart} or NULL, if parallel has already
been started by the caller.}

\item{use_cache}{\link{logical} set to FALSE to omit re-using already distributed
study- and metadata on a parallel cluster}
}
\value{
\link{list} of results of the function calls
}
\description{
Parallel version of \code{\link[purrr:map2]{purrr::pmap}}.
}
\seealso{
\link[purrr:map2]{purrr::pmap}

\href{https://stackoverflow.com/a/47575143}{Stack Overflow post}
}
\author{
\href{https://stackoverflow.com/users/6197649}{Aurèle}

S Struckmann
}
