% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNode.R
\docType{methods}
\name{resolve}
\alias{resolve}
\alias{resolve,CNode-method}
\title{Get a list of coordinating nodes holding a given pid.}
\usage{
resolve(x, ...)

\S4method{resolve}{CNode}(x, pid)
}
\arguments{
\item{x}{a valid CNode object}

\item{...}{Additional arguments (not yet used).}

\item{pid}{the id of the identified object}
}
\value{
A list of URLs that the object can be downloaded from, or NULL if the object is not found.
}
\description{
Returns a list of nodes (MNs or CNs) known to hold copies of the object identified by id.
}
\examples{
\dontrun{
library(dataone)
cn <- CNode("STAGING")
id <- "doi:10.6073/pasta/9a27a1615e8e4c366ad09fefbfa2fced"
locations <- resolve(cn,id)
}
}
