% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{pinusSpp2}
\alias{pinusSpp2}
\title{Variables a nivel de árbol en parcelas de muestreo de Pinus spp en Chile.}
\format{
Contains 8 variables, as follows:
\describe{
\item{parcela}{Numero de la parcela.}
\item{sup.parcela}{Superficie de la parcela, en m\eqn{^{2}}{^2}.}
\item{lat.s}{Decimal coordinate of S latitude.}
\item{long.w}{Decimal coordinate of W longitude.}
\item{indv.id}{Identificador del árbol en la parcelaeach plot. Same indv/id for multi-stem trees.}
\item{fuste.id}{Identificador del fuste.}
\item{especie}{Especie.}
\item{dap}{diámetro a la altura del pecho, en cm.}
\item{h}{Altura total, en m.}
\item{hcc}{Altura comienzo de copa, en m.}
\item{largo.copa}{Largo de copa, en m.}
\item{obs}{Observacion.}
}
}
\source{
Los datos fueron cedidos por los Drs. Anibal Pauchard y Rafael Garcia del Laboratorio de Invasiones
 Biologicas, Universidad de Concepción (Chile).
}
\usage{
data(pinusSpp2)
}
\description{
Mediciones a nivel de árbol para estudiar la invasion de Pinus spp en bosques de Araucaria-Nothofagus en 
la Reserva Nacional Malalcahuello en la region de la Araucania en el sur de Chile. 
Hay 26 parcelas, y la superficie de cada una es de 100 m\eqn{^{2}}{^2}.
}
\examples{
data(pinusSpp2)    
head(pinusSpp2) 
length(unique(pinusSpp2$parcela)) 
boxplot(dap~parcela, data=pinusSpp2) 
}
\references{
Cobar-Carranza A, Garcia R, Pauchard A & Pena E. 2014. Effect of Pinus contorta invasion on forest fuel properties and
 its potential implications on the fire regime of Araucaria araucana and Nothofagus antarctica forests.
 Biological Invasions. 16(11): 2273-2291. \doi{10.1007/s10530-014-0663-8}
}
\keyword{datasets}
