% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{grGrandfir2}
\alias{grGrandfir2}
\title{Crecimiento en altura y diametro de árboles de Abies grandis.}
\format{
Los datos contienen las siguientes columnas:
\describe{
\item{bosque}{Reserva forestal nacional}	
\item{bosque.id}{Codigo de reserva forestal nacional}	
\item{tipo.hab}{Tipo de habitat}
\item{hab.id}{Codigo de tipo de habitat}
\item{arbol.id}{Codigo del árbol}											
\item{decada}{Decada, como un entero.}	
\item{edad}{Edad total, en años.}
\item{dap}{Diametro a altura del pecho, en cm.}
\item{atot}{Altura total, en m.}
 }
}
\source{
Los datos fueron medidos por el Dr Albert Stage (Q.E.P.D.), del US Forest Service
 en Moscow, Idaho, USA. Los datos fueron compilados por el Prof. Andrew Robinson para sus clases 
 de estadística en la University of Idaho (USA), mientras el Dr Christian Salas-Eljatib era
 un estudiante ahi, y alumno tesista del Dr Stage.
}
\usage{
data(grGrandfir2)
}
\description{
Crecimiento en altura y diametro de árboles de Abies grandis en Idaho, USA. 
Los datos contienen mediciones de 66 árboles dominantes seleccionados desde
 reservas nacionales forestales en el estado de Idaho, USA. Los datos estan
 mas detallados en Stage (1963).
}
\examples{
data(grGrandfir2)    
head(grGrandfir2)
library(lattice)
xyplot(dap ~ edad | arbol.id, type="b", data=grGrandfir2) 
}
\references{
- Stage, A. R., 1963. A mathematical approach to polymorphic site index curves
  for Grand fir. Forest Science 9(2):167-180. \doi{10.1093/forestscience/9.2.167}
}
\keyword{datasets}
