% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{orange2}
\alias{orange2}
\title{Crecimiento diametral de arboles de naranjo}
\format{
A time series data containing the following columns:
\describe{
\item{arbol}{indica el identificador del arbol.}
\item{tiempo}{numero de dias desde el 31 de diciembre de 1968.}
\item{peri}{el perimetro del tronco (mm), medido a la altura del pecho.}
\item{dap}{diametro a la altura del pecho (mm).}
\item{sitio}{un factor, representando condiciones de sitio, en dos niveles.}
\item{especie}{un factor, representando especie del arbol, en tres niveles.}
 }
}
\source{
Modificado por Christian Salas-Eljatib desde la dataframe Orange de R.
}
\usage{
data(orange2)
}
\description{
The orange data frame has 35 rows and four columns of records of the growth of orange trees.
}
\examples{
data(orange2)

coplot(dap ~ tiempo | arbol, data = orange2, show.given = FALSE)
m1 <- nls(dap ~ SSlogis(tiempo, Asym, xmid, scal),
           data = orange2, subset = arbol == 3)
plot(dap ~ tiempo, data = orange2, subset = arbol== 3,
     xlab = "Tiempo (numero de dias desde 31/12/1968)",
     ylab = "Diametro (mm)", las = 1)
tiempo <- seq(0, 1600, length.out = 101)
lines(tiempo, predict(m1, list(tiempo = tiempo)))
}
\keyword{datasets}
