% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-data.R
\name{module-sample}
\alias{module-sample}
\alias{sample_ui}
\alias{sample_server}
\title{Shiny module to interactively sample a \code{data.frame}}
\usage{
sample_ui(id)

sample_server(id, data_r = reactive(NULL))
}
\arguments{
\item{id}{Module id. See \code{\link[shiny:moduleServer]{shiny::moduleServer()}}.}

\item{data_r}{\code{reactive} containing a \code{data.frame} to use in the module.}
}
\value{
\itemize{
\item UI: HTML tags that can be included in shiny's UI
\item Server: a \code{reactive} fgunction with the sampled data.
}
}
\description{
Allow to take a sample of \code{data.frame} for a given number or proportion of rows to keep.
}
\examples{
library(shiny)
library(reactable)

##### ui.R #####

ui <- fluidPage(

  titlePanel("Sampling"),

  fluidRow(
    column(
      width = 4,
      sample_ui("myID")
    ),
    column(
      width = 8,
      reactableOutput("table")
    )
  )
)



##### server.R #####

server <- function(input, output, session) {

  result_sample <- sample_server("myID", reactive(iris))

  output$table <- renderReactable({
    table_sample <- reactable(
      data = result_sample(),
      defaultColDef = colDef(
        align = "center"
      ),
      borderless = TRUE,
      highlight = TRUE,
      striped = TRUE
    )
    return(table_sample)
  })
}

if (interactive())
  shinyApp(ui, server)

}
