% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_choropleth}
\alias{add_choropleth}
\title{Add choropleth}
\usage{
add_choropleth(p, locations, color, ..., colors = c("#FFEDA0", "#FEB24C",
  "#F03B20"))
}
\arguments{
\item{p}{a datamaps object.}

\item{locations}{column containing location names as \code{iso3c}.}

\item{color}{column containing color of each \code{location}.}

\item{...}{any other variable to use for tooltip.}

\item{colors}{color palette.}
}
\description{
Add choropleth data.
}
\examples{
data <- data.frame(name = c("USA", "FRA", "CHN", "RUS", "COG", "DZA"),
    color = round(runif(6, 1, 10)))

data \%>\%
    datamaps() \%>\%
    add_choropleth(name, color, colors = c("skyblue", "yellow", "orangered"))

# categorical colors
cat <- data.frame(name = c("USA", "BRA", "COL", "CAN", "ARG", "CHL"),
    col = rep(c("Yes", "No"), 6))

cat \%>\%
    datamaps(projection = "orthographic") \%>\%
    add_choropleth(name, col, colors = c("red", "blue"))

# US states
states <- data.frame(st = c("AR", "NY", "CA", "IL", "CO", "MT", "TX"),
    val = c(10, 5, 3, 8, 6, 7, 2))

states \%>\%
    datamaps(scope = "usa", default = "lightgray") \%>\%
    add_choropleth(st, val) \%>\%
    add_labels()

}
