% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-data1.R
\name{check_data1}
\alias{check_data1}
\title{Check Data1}
\usage{
check_data1(data, values = NULL, min_row = 0, max_row = max_nrow(),
  key = character(0), data_name = substitute(data))
}
\arguments{
\item{data}{The data frame to check.}

\item{values}{A named list specifying the columns and
their associated classes and values.}

\item{min_row}{A count of the minimum number of rows.}

\item{max_row}{A count of the maximum number of rows.}

\item{key}{A character vector of the column names representing the key.}

\item{data_name}{A string of the name of data.}
}
\value{
Throws an informative error or returns an invisible copy of
data.
}
\description{
Checks a data frame's rows, columns, classes and values and key.
}
\details{
\code{check_data1} enforces minimal contraints.
By default it does not require data to have any rows or columns.
It also allows NULLs in values and does not
require column names in values to be unique.

For stricter data checking see \code{\link{check_data2}}
and \code{\link{check_data3}}.
}
