% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readNWISdata.r
\name{stateCdLookup}
\alias{stateCdLookup}
\title{State code look up}
\usage{
stateCdLookup(input, outputType = "postal")
}
\arguments{
\item{input}{could be character (full name, abbreviation, id), or numeric (id)}

\item{outputType}{character can be "postal","fullName","tableIndex", or "id".}
}
\description{
Function to simplify finding state and state code definitions. Used in \code{readNWISdata}
and \code{readWQPdata}.
}
\examples{
fullName <- stateCdLookup("wi", "fullName")
abbriev <- stateCdLookup("Wisconsin", "postal")
id <- stateCdLookup("WI", "id")
name <- stateCdLookup(55, "fullName")
index <- stateCdLookup("WI", "tableIndex")
stateCd[index,]
}

