% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/readNWISunit.r
\name{readNWISgwl}
\alias{readNWISgwl}
\title{Groundwater level measurements retrieval from USGS (NWIS)}
\usage{
readNWISgwl(siteNumbers, startDate = "", endDate = "")
}
\arguments{
\item{siteNumbers}{character USGS site number (or multiple sites).  This is usually an 8 digit number}

\item{startDate}{character starting date for data retrieval in the form YYYY-MM-DD. Default is "" which indicates
retrieval for the earliest possible record.}

\item{endDate}{character ending date for data retrieval in the form YYYY-MM-DD. Default is "" which indicates
retrieval for the latest possible record.}
}
\value{
A data frame with the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
agency_cd \tab character \tab The NWIS code for the agency reporting the data\cr
site_no \tab character \tab The USGS site number \cr
site_tp_cd \tab character \tab Site type code \cr
lev_dt \tab Date \tab Date level measured\cr
lev_tm \tab character \tab Time level measured \cr
lev_tz_cd \tab character \tab Time datum \cr
lev_va \tab numeric \tab Water level value in feet below land surface\cr
sl_lev_va \tab numeric \tab Water level value in feet above specific vertical datum \cr
lev_status_cd \tab character \tab The status of the site at the time the water level was measured \cr
lev_agency_cd \tab character \tab The agency code of the person measuring the water level \cr
}

There are also several useful attributes attached to the data frame:
\tabular{lll}{
Name \tab Type \tab Description \cr
url \tab character \tab The url used to generate the data \cr
queryTime \tab POSIXct \tab The time the data was returned \cr
comment \tab character \tab Header comments from the RDB file \cr
siteInfo \tab data.frame \tab A data frame containing information on the requested sites \cr
}
}
\description{
Reads groundwater level measurements from NWISweb. Mixed date/times come back from the service
depending on the year that the data was collected. See \url{http://waterdata.usgs.gov/usa/nwis/gw}
for details about groundwater. Groundwater dates and times are returned in many different formats, therefore the
date/time information is returned as a character string. Users will need to convert to a date object.
See \url{http://waterservices.usgs.gov/rest/GW-Levels-Service.html} for more information.
}
\examples{
siteNumber <- "434400121275801"
\dontrun{
data <- readNWISgwl(siteNumber, '','')
sites <- c("434400121275801", "375907091432201")
data2 <- readNWISgwl(sites, '','')
data3 <- readNWISgwl("420125073193001", '','')
}
}
\seealso{
\code{\link{constructNWISURL}}, \code{\link{importRDB1}}
}

