% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setColAs.R
\name{setColAsFactor}
\alias{setColAsFactor}
\title{Set columns as factor}
\usage{
setColAsFactor(dataSet, cols = "auto", n_levels = 53, verbose = TRUE)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{cols}{List of column(s) name(s) of dataSet to transform into factor. To transform all columns
set it to "auto", (characters, default to auto).}

\item{n_levels}{Max number of levels for factor (integer, default to 53) 
set it to -1 to disable control.}

\item{verbose}{Should the function log (logical, default to TRUE)}
}
\value{
\code{dataSet}(as a \code{\link{data.table}}), with specified columns set as factor or logical.
}
\description{
Set columns as factor and control number of unique element, to avoid having too large factors.
}
\details{
Control number of levels will help you to distinguish true categorical columns from just characters 
that should be handled in another way.
}
\examples{
# Load messy_adult
data("messy_adult")

# we wil change education
messy_adult <- setColAsFactor(messy_adult, cols = "education")

sapply(messy_adult[, .(education)], class)
# education is now a factor
}
