% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/node_methods.R
\name{GetAttribute}
\alias{GetAttribute}
\title{Get an attribute from a Node.}
\usage{
GetAttribute(node, attribute, ..., format = NULL,
  inheritFromAncestors = FALSE, nullAsNa = TRUE)
}
\arguments{
\item{node}{The \code{\link{Node}} from which the \code{attribute} should be fetched.}

\item{attribute}{determines what is collected. The \code{attribute} can be
\itemize{
  \item a.) the name of a \bold{field} of each \code{Node} in the tree
  \item b.) the name of a \bold{method} of each \code{Node} in the tree
  \item c.) a \bold{function}, whose first argument must be a \code{Node}
 }}

\item{...}{in case the \code{attribute} is a function or a method, the ellipsis is passed to it as additional arguments.}

\item{format}{can be a function that transforms the collected values, e.g. for printing}

\item{inheritFromAncestors}{if \code{TRUE}, then the path above a \code{Node} is searched to get the \code{attribute} in case it is NULL.}

\item{nullAsNa}{If TRUE (the default), then NULL is returned as NA. Otherwise it is returned as NULL.}
}
\description{
Get an attribute from a Node.
}
\examples{
data(acme)
GetAttribute(acme$IT$Outsource, "cost")
}

